﻿# Urban Commons as a Driver of Social Inclusion: A Socio-Spatial Analysis of the Accessibility to Urban Commons in Amsterdam
## Complementary material: Codes README file

This is  the accompanying code to  the Master Thesis research project "Urban Commons as a Driver of Social Inclusion: A Socio-Spatial Analysis of the Accessibility to Urban Commons in Amsterdam" conducted in cooperation with  the CUSP Lab at TU Delft's Technology, Policy and Management faculty.  Aiming to assess the material accessibility of the Urban Commons in the thesis's case study, three Jupyter notebooks were used to 
 1. conduct an Exploratory Spatial Data Analysis of the datasets and
    categorize each neighborhood according to their socio-demographic
    profile, 
2. generate the transit times between different points in
    Amsterdam to each of the case study Urban Commons, and  
3. generate visualizations to analyze the transit-time matrix.

Their content is described below  in further detail. 

**Structure**: The key operations were performed in Python, including the explorations of the data, the classification of the neighborhoods, and the maps visualizations. Further wrangling and analysis of the data were conducted in external environments, such as in MS Power BI or MS Excel.

## Prerequesites *
 Python 3.x * 
 Packages and dependencies in ```ettore_thesis_env.yml``` 
## 1 - ESDA and Neighborhood Classification 
This notebook provides the functions and performs the operations used to explore the input data from a spatial perspective (Exploratory Spatial Data Analysis) and the algorithm used to classify the Amsterdam neighborhoods according to census demographic data. Further details can be seen in the notebook's documentation.
## 2 - Amsterdam Accessibility Analysis Generating Transit Times
This notebook provides the functions and the APIs used to split Amsterdam into multiple hexagons and generate the transit times between each hexagon's centroid and the Urban Commons in the case study.
## 03 Amsterdam Accessibility Analysis Visualizations 
This notebook provides the functions and operations used to visualize the results from notebook 2 on a map.
```
